template<class TYPE>
class Array : public std::vector<TYPE>
{
public:
  Array () {} 
  Array (size_t size) : vector<TYPE>(size) {} 
  Array (size_t size, const TYPE &value) : vector<TYPE>(size, value) {} 
  Array (const Array &source) : vector<TYPE>(source) {} 
  TYPE &operator[](size_t) ;
  const TYPE &operator[] (size_t) const ;
} ;

#if defined (ENABLECHECKS)
template<class TYPE>
inline TYPE &Array<TYPE>::operator[](size_t index)
{
  return vector<TYPE>::at (index) ;
}
template<class TYPE>
inline const TYPE &Array<TYPE>::operator[](size_t index) const
{
  return vector<TYPE>::at (index) ;
}
#else
template<class TYPE>
inline TYPE &Array<TYPE>::operator[](size_t index)
{
  return vector<TYPE>::operator[](index) ;
}
template<class TYPE>
inline const TYPE &Array<TYPE>::operator[](size_t index) const
{
  return vector<TYPE>::operator[](index) ;
}
#endif
